/*    Foundation Window/Control Resource Editor Module  */
#pragma noroot
#include <foundation.h>
#include <event.h>


extern EventRecordPtr fEventPtr;

    char                tempText[8][256];
                        /* 0 = Ctl ID     8 bytes max */
                        /* 1 = RefCon     8 bytes max */
                        /* 2 = icon clrs  2 bytes max  icon button only */
                        /* 3 = member ht  5 bytes max */
                        /* 4 = title wd   5 bytes max */
                        /* 5 = initialval 5 bytes max */
                        /* 6 = Title      80 bytes max ? */
    char                tempName;
    word                TEType[] = { rPString, rCString, rC1InputString,
                                    rC1OutputString, rTextForLETextBox2, rText };
    word                ~TOOLERROR,
		                ~USERID,
                        edUserID,
                        edResFileID,
                        shResFileID,
    	                fdResFileID,
                        bad,
                        temp;
    fPrivateDataRec 	PrivPB;
    fResDataRec     	DataPB;
    fResData2Rec    	Data2PB;
    fResNameRec     	NamePB;
    fResRefRec      	RefPB;
    fResCopyRec			CopyPB;
    fResLinkRec			LinkPB;
    fResConverterRec	ConvertPB;
    fGetFileRec			FilePB;
    WinTemplatePtr      edWin;
    WinTemplatePtr      wkWin;
    long                *edCtlList;
    long                *wkCtlList;
    control             edCtl;
    privateDataHndl     private;
    privateDataPtr      pPtr;

void SetWorkingData(GrafPortPtr winP, word Task)
{
    if (task) {     /* we want to get our data */
        PrivPB.pCount = 4;
	    PrivPB.winPtr = winP;
	    PrivPB.TaskMask = 0L;
	    PrivPB.remSignature = 0;
	    PrivPB.Data = (Handle) private;
        fGetPrivateData(&PrivPB);
        pPtr = deref(private);
        edWin = deref(pPtr->edTempH);
        wkWin = deref(pPtr->wkTempH);
    }
    else              /* we want to put away our toys for now */
        PrivPB.pCount = 4;
	    PrivPB.winPtr = winP;
	    PrivPB.TaskMask = 0L;
	    PrivPB.remSignature = 0;
	    PrivPB.Data = (Handle) private;
        fSetPrivateData(&PrivPB);
        HUnlock(pPtr->edTempH);
        HUnlock(pPtr->wkTempH);
        HUnlock(private);
    }
}

Handle LoadRes(word type , long ID)
{
fResDataRec     	thePB;

    thePB.pCount = 3;
	thePB.resType = type;
	thePB.resID = ID;
    bad = fLoadResource(&thePB);
    return thePB.resData;
}

void ReleaseRes(word type , long ID)
{
fResRefRec     	    thePB;

    thePB.pCount = 2;
	thePB.resType = type;
	thePB.resID = ID;
    bad = fReleaseResource(&thePB);
}

Handle RevertResData(word rType, long rID, Handle resData);
{
Handle              wblk;

    wblk = (Handle) GetResData(rType, rID, locked);
    DisposeHandle(resData);
    return wblk;
}

Handle UpdateResData(word rType, long rID, Handle resData, word locked);
}
Handle              sblk, wblk;
long                hansize;

    hansize = GetHandleSize(resData);
    HLock(resData);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(resData, wblk, hansize);
    RefPB.pCount = 2;
    RefPB.resType = rType;
    RefPB.resID = rID;
    fRemoveResource(&RefPB);
    DataPB.pCount = 3;
    DataPB.resType = rType;
    DataPB.resID = rID;
    DataPB.resData = wblk;
    fAddResource(&DataPB);
    ReleaseRes(rType, rID)
    if (!locked)
        HUnlock(wblk);
    return resData;;
}

void SetWindMenu (word enable, GrafPortPtr winP)
{
word                i;
CtlRecHndl		    menuBarH;

    menuBarH = GetMenuBar();
    SetMenuBar(GetCtlHandleFromID(winP, 0x500L));
    for (i = 0x50A; i < 0x511; i++)
        {
        if (enable)
            EnableMItem(i);
        else
            DisableMItem(i);
        }
}

long GetResData(word rType, long rID, word locked);
}
Handle      sblk, wblk;
long        hansize;

	sblk = LoadRes(rType, rID);
    hansize = GetHandleSize(sblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(sblk, wblk, hansize);
    ReleaseRes(rType, rID)
    if (!locked)
        HUnlock(wblk);
    return (long) wblk;
}

long GetListRef(long rID, word lCount, word lSize);
{
Handle              sblk, wblk, transblk;
multiPtr            eptr, wptr;
word                i;
long                hansize;

	sblk = LoadRes(rType, rID);
    hansize = GetHandleSize(sblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(sblk, wblk, hansize);
    eptr.Ptr = deref (sblk);
    wptr.Ptr = deref (wblk);
	for (i = 0; i < lCount; i++, ePtr.Ptr += lSize, wptr.Ptr += lSize)
    {
        transblk = (Handle) GetResData(rPString, *eptr.lptr, 1);
        *wptr.lptr = *transblk;
    }
    ReleaseRes(rType, rID)
    return (long) *wblk;
}

long GetItemStruct(long rID);
{
Handle              eblk, wblk;
MenuTemplatePtr     eptr, wptr;
long                hansize;

	eblk = (Handle) GetResData(rItemStruct, rID, 1);
    hansize = GetHandleSize(eblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(eblk, wblk, hansize);
    eptr = (itemStructPtr) deref(eblk);
    wptr = (itemStructPtr) deref(wblk);
    wptr->itemFlag2 &= 0x7ffc;
    wptr->itemIconRef = GetResData(rIcon, eptr->itemIconRef, 1);
    if (wptr->itemIconRef)
        wptr->itemFlag2 |= 0x8001;
    wptr->itemTitleRef = GetResData(rPString, eptr->itemTitleRef, 1);
    if (wptr->itemTitleRef)
        temp = 1;
    ReleaseRes(rMenuItem, rID);
    return (long) wblk;
 }

long GetMenuItem(long rID);
{
Handle              eblk, wblk;
MenuTemplatePtr     eptr, wptr;
long                hansize;

	eblk = (Handle) GetResData(rMenuItem, rID, 1);
    hansize = GetHandleSize(eblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(eblk, wblk, hansize);
    eptr = (MenuItemTemplatePtr) deref(eblk);
    wptr = (MenuItemTemplatePtr) deref(wblk);
    temp = 0;
    wptr->itemFlag &= 0x3cff;
    if (eptr->itemFlag & 0x0400) /* we have an item struct here */
        {
        wptr->itemFlag |= 0x0100;
        wptr->itemTitleRef = GetItemStruct(eptr->itemTitleRef);
        if (temp)
            wptr->itemFlag |= 0x4000;
    else                         /* if not, we have a PString here */
        wptr->itemTitleRef = GetResData(rPString, eptr->itemTitleRef, 1);
        if (wptr->itemTitleRef)
            wptr->itemFlag |= 0x4000;
    ReleaseRes(rMenuItem, rID);
    return (long) wblk;
}

long GetMenu(long rID);
{
Handle              eblk, wblk;
MenuTemplatePtr     eptr, wptr;
long                hansize;

	eblk = (Handle) GetResData(rMenu, rID, 1);
    hansize = GetHandleSize(eblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(eblk, wblk, hansize);
    eptr = (MenuTemplatePtr) deref(eblk);
    wptr = (MenuTemplatePtr) deref(wblk);
    wptr->menuFlag &= 0x0fff;
    wptr->menuTitleRef = GetResData(rPString, eptr->menuTitleRef, 1);
    if (wptr->menuTitleRef)
        wptr->menuFlag |= 0x4000;
    for (i = 0; eptr->itemRefArray[i] != 0L; i++)
        wptr->itemRefArray[i] GetMenuItem(eptr->itemRefArray[i]);
    if (wptr->itemRefArray[0])
        wptr->menuFlag |= 0x1000;
    ReleaseRes(rMenu, rID);
    return (long) wblk;
}

long GetColorTbl(long rID, word dep);
{
Handle              eblk, wblk;
TEColorTablePtr     eptr, wptr;
long                hansize;

	eblk = (Handle) GetResData(rColorTable, rID, 0);
    hansize = GetHandleSize(eblk);
	wblk = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(eblk, wblk, hansize);
    if (dep)        /* if true, it's a TE Block */
    {
        eptr = (TEColorTablePtr) deref(eblk);
        wptr = (TEColorTablePtr) deref(wblk);
        wptr->vertColorRef = GetResData(rColorTable, eptr->vertColorRef, 0);
        if (wptr->vertColorRef)
        {
            wptr->vertColorDescriptor = 4;
            ReleaseRes(rColorTable, eptr->vertColorRef)
        }
        else
            wptr->vertColorDescriptor = 0;
        wptr->horzColorRef = GetResData(rColorTable, eptr->horzColorRef, 0);
        if (wptr->horzColorRef)
        {
            wptr->horzColorDescriptor = 4;
            ReleaseRes(rColorTable, eptr->horzColorRef)
        }
        else
            wptr->horzColorDescriptor = 0;
        wptr->growColorRef = GetResData(rColorTable, eptr->growColorRef, 0);
        if (wptr->growColorRef)
        {
            wptr->growColorDescriptor = 4;
            ReleaseRes(rColorTable, eptr->growColorRef)
        }
        else
            wptr->growColorDescriptor = 0;
    }
    ReleaseRes(rColorTable, rID);
    HUnlock(wblk);
    return (long) wblk;
}

long GetWkCtl (long rID)
{
long                procRef, hansize, wkID, edID;
word                pCount, i, ctlMore;
Handle              edCtl, wkCtl;
control             wkControl, edControl;

	edCtl = LoadRes(rControlTemplate, rID);
    hansize = GetHandleSize(edCtl);
	wkCtl = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(pPtr->edCtl, wkCtl, hansize);
    edControl.dummy = deref(edCtl);
    wkControl.dummy = deref(wkCtl);
    procRef = edControl.BcPtr->ctlTemplate.procRef;
    switch (procRef)
    {
        case simpleButtonControl:
            {
            ctlMore = edControl.BcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xfff0;
            wkControl.BcPtr->titleRef = GetResData(rPString, edControl.BcPtr->titleRef), 0);
            if (wkControl.BcPtr->titleRef)
                ctlMore |= 0x0001;
            wkControl.BcPtr->colorTableRef = GetColorTbl(edControl.BcPtr->colorTableRef, 0);
            if (wkControl.BcPtr->colorTableRef)
                ctlMore |= 0x0004;
            wkControl.BcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case checkControl:
            {
            ctlMore = edControl.CBcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xfff0;
            wkControl.CBcPtr->titleRef = GetResData(rPString, edControl.CBcPtr->titleRef, 0);
            if (wkControl.CBcPtr->titleRef)
                ctlMore |= 0x0001;
            wkControl.CBcPtr->colorTableRef = GetColorTbl(edControl.CBcPtr->colorTableRef, 0);
            if (wkControl.CBcPtr->colorTableRef)
                ctlMore |= 0x0004;
            wkControl.CBcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case iconButtonControl:
        case 0x07ff0001:
            {
            ctlMore = edControl.CBcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xffc0;
            wkControl.IcPtr->iconRef = GetResData(rIcon, edControl.IcPtr->iconRef, 0);
            if (wkControl.IcPtr->iconRef)
                ctlMore |= 0x0010;
            wkControl.IcPtr->titleRef = GetResData(rPString, edControl.IcPtr->titleRef, 0);
            if (wkControl.IcPtr->titleRef)
                ctlMore |= 0x0001;
            wkControl.IcPtr->colorTableRef = GetColorTbl(edControl.IcPtr->colorTableRef, 0);
            if (wkControl.IcPtr->colorTableRef)
                ctlMore |= 0x0004;
            wkControl.IcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case editLineControl:
            {
            ctlMore = edControl.LEcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xffFc;
            wkControl.LEcPtr->defaultRef = GetResData(rPString, edControl.LEcPtr->defaultRef, 0);
            if (wkControl.LEcPtr->defaultRef)
                ctlMore |= 0x0001;
            wkControl.LEcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case listControl:
            {
            ctlMore = edControl.LcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xffF0;
            wkControl.LcPtr->listRef = GetListRef(edControl.LcPtr->listRef,
                edControl.LcPtr->listSize, edControl.LcPtr->listMemSize);
            if (wkControl.LcPtr->listRef)
                ctlMore |= 0x0000;   /* we use a pointer here!  SHEESH!  */
            wkControl.LcPtr->colorTableRef = GetColorTbl(edControl.LcPtr->colorTableRef, 0);
            if (wkControl.LcPtr->colorTableRef)
                ctlMore |= 0x0004;
            wkControl.LcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case pictureControl:
            {
            ctlMore = edControl.PcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xffF0;
            wkControl.PcPtr->pictureRef = GetResData(rPicture, edControl.PcPtr->pictureRef, 0);
            if (wkControl.PcPtr->pictureRef)
                ctlMore |= 0x0001;
            wkControl.PcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
        case popUpControl:
            {
            ctlMore = edControl.PMcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xffe0;
            wkControl.PMcPtr->menuRef = GetMenu(edControl.PMcPtr->menuRef);
            if (wkControl.PMcPtr->menuRef)
                ctlMore |= 0x0001;
            wkControl.PMcPtr->colorTableRef = GetMenu(edControl.PMcPtr->colorTableRef);
            if (wkControl.PMcPtr->colorTableRef)
                ctlMore |= 0x0008;
            wkControl.PMcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case radioControl:
            {
            ctlMore = edControl.CBcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xfff0;
            wkControl.CBcPtr->titleRef = GetResData(rPString, edControl.CBcPtr->titleRef, 0);
            if (wkControl.CBcPtr->titleRef)
                ctlMore |= 0x0001;
            wkControl.CBcPtr->colorTableRef = GetColorTbl(edControl.CBcPtr->colorTableRef, 0);
            if (wkControl.CBcPtr->colorTableRef)
                ctlMore |= 0x0004;
            wkControl.CBcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case scrollBarControl:
            {
            ctlMore = edControl.SBcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xfff3;
            wkControl.SBcPtr->colorTableRef = GetColorTbl(edControl.SBcPtr->colorTableRef, 0);
            if (wkControl.SBcPtr->colorTableRef)
                ctlMore |= 0x0004;
            wkControl.SBcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case growControl:
            {
            ctlMore = edControl.GcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xfff3;
            wkControl.GcPtr->colorTableRef = GetColorTbl(edControl.GcPtr->colorTableRef, 0);
            if (wkControl.GcPtr->colorTableRef)
                ctlMore |= 0x0004;
            wkControl.GcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case statTextControl:
            {
            ctlMore = edControl.BcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xfffc;
            wkControl.BcPtr->titleRef = GetResData(rTextForLETextBox2, edControl.BcPtr->titleRef, 0);
            if (wkControl.BcPtr->titleRef)
                ctlMore |= 0x0001;
            wkControl.BcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case editTextControl:
            {
            ctlMore = edControl.TEcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xfff0;
            wkControl.TEcPtr->styleRef = GetResData(rStyleBlock, edControl.TEcPtr->styleRef, 0);
            if (wkControl.TEcPtr->styleRef)
                ctlMore |= 0x0001;
            wkControl.TEcPtr->ColorTableRef = GetColorTbl(edControl.TEcPtr->colorTableRef, 1);
            if (wkControl.TEcPtr->colorTableRef)
                ctlMore |= 0x0004;
            i = wkControl.TEcPtr->textDescriptor & 0x0007;
            wkControl.TEcPtr->textDescriptor &= 0xffe7;
            wkControl.TEcPtr->textRef = GetResData(TEType[i], edControl.TEcPtr->textRef, 0);
            if (wkControl.TEcPtr->textRef)
                wkControl.TEcPtr->textDescriptor |= 0x0008;
            wkControl.TEcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
        case rectangleControl:
            {
                break;
            }
        case thermometerControl:
            {
            ctlMore = edControl.TcPtr->ctlTemplate.moreFlags;
            ctlMore &= 0xfffc;
            wkControl.TcPtr->ColorTableRef = GetColorTbl(edControl.TcPtr->colorTableRef, 0);
            if (wkControl.TcPtr->colorTableRef)
                ctlMore |= 0x0001;
            wkControl.TcPtr->ctlTemplate.moreFlags = ctlMore;
            break;
            }
    }
    HUnlock(edCtl);
    ReleaseRes(rControlTemplate, rID)
    HUnlock(wkCtl);
    return (long) wkCtl;
}

long GetWkMenuBar (long rID)
{
word                i;
long                hansize, wkID, edID, *wkPtr, *edPtr;

	pPtr->edMenuBarH = LoadRes(rMenuBar, rID);
    hansize = GetHandleSize(pPtr->edMenuBarH);
	pPtr->wkMenuBarH = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(pPtr->edMenuBarH, pPtr->wkMenuBarH, hansize);
    edPtr = deref(pPtr->edMenuBarH);
    wkPtr = deref(pPtr->wkMenuBarH);
    *wkPtr = 0x0001;
    for (i = 0; edPtr[i + 1] != 0L; i++)
    {
        edID = edPtr[i + 1];
        wkID = GetMenu(edID);
        wkPtr[i + 1] = wkID;
    }
    HUnlock(pPtr->edMenuBarH);
    HUnlock(pPtr->wkMenuBarH);
    return (long) pPtr->wkMenuBarH;
}

long GetWkCtlList (long rID)
{
long                hansize;
long                *wkPtr;
long                *edPtr;
long                wkID;
long                edID;
word                i;

	pPtr->edCtlListH = LoadRes(rControlList, rID);
    hansize = GetHandleSize(pPtr->edCtlListH);
	pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
    HandToHand(pPtr->edCtlListH, pPtr->wkCtlListH, hansize);
    edPtr = deref(pPtr->edCtlListH);
    wkPtr = deref(pPtr->wkCtlListH);
    for (i = 0; edPtr[i] != 0L; i++)
    {
        edID = edPtr[i];
        wkID = GetWkCtl(edID);
        wkPtr[i] = wkID;
    }
    HUnlock(pPtr->edCtlListH);
    HUnlock(pPtr->wkCtlListH);
    return (long) pPtr->wkCtlListH;
}

word REM_OPEN(fSessionRecPtr p)
{
word                retVal, retErr, windKind, action;
long                winTempID, procRef, hansize, *wkPtr, *edPtr;
Handle	            title, ctlHndl;
CtlRecHndl          tempCtl;
control             wkCtl;

    switch (p->resType) {
        case rControlList:
        case rControlTemplate:
        case rCtlColorTbl:
        case rWindParam1:
        case rWindColor:
        case rMenuBar:
        case rMenu:
        case rMenuItem:
        {
            break;
        };
        default {
            return fErrTypeInvalid;
            }
    }

	if (!Data.resID || (p->fFlag & (OPEN_SILENT | OPEN_DATA))) {

		if (p->Flag & OPEN_DATA) 		/* data is provided - handle is ours */
        	DataPB.resData = p->Data;

        else {							/* no data, load default from editor */
        	DataPB.pCount = 6;
			DataPB.resType = p->resType;;
			DataPB.resID = 0x00030000L + (long) p->resType;
			DataPB.resFileID = edResFileID;
			resErr = fLoadResource(&DataPB);
        	RefPB.pCount = 3;
			RefPB.resType = p->resType;
			RefPB.resID = 0x00030000L + (long) p->resType;
			RefPB.resFileID = edResFileID;
			resErr = fDetachResource(&DataPB);
		}
        DataPB.pCount = 4;
		DataPB.resID = p->resID;		/* if null, then Add returns ID added */
		DataPB.special = 0;				/* no attributes assigned */
		resErr = fAddResource(&DataPB);
        p->resID = DataPB.resID;		/* this may change so pass it back */
        if (p->flag & OPEN_SILENT) {
        	RefPB.pCount = 2;
			RefPB.resType = p->resType;
			RefPB.resID = DataPB.resID;
			resErr = fReleaseResource(&DataPB);
           	return 0;
        }
	}
    switch (p->resType) {
        case rWindParam1:
            {
                winTempID = 0x0500L;
                windKind = 0x01;
                break;
            }
        case rControlList:
            {
                winTempID = 0x0550L;
                windKind = 0x02;
                break;
            }
        case rControlTemplate:
            {
                ctlHndl = LoadRes(p->resType, p->resID);
                ctl.dummy = (Pointer) *ctlHndl;
                procRef = ctl.BcPtr->ctlTemplate.procRef;
                ReleaseRes(p->resType, p->resID);
                switch (procRef)
                    {
                        case simpleButtonControl:
                        {
                            winTempID = 0x10001L;
                            windKind = 0x04;
                            break;
                        }
                        case checkControl:
                        {
                            winTempID = 0x10002L;
                            windKind = 0x05;
                            break;
                        }
                        case iconButtonControl:
                        case 0x07ff0001:
                        {
                            winTempID = 0x10003L;
                            windKind = 0x06;
                            break;
                        }
                        case editLineControl:
                        {
                            winTempID = 0x10004L;
                            windKind = 0x07;
                            break;
                        }
                        case listControl:
                        {
                            winTempID = 0x10005L;
                            windKind = 0x08;
                            break;
                        }
                        case pictureControl:
                        {
                            winTempID = 0x10006L;
                            windKind = 0x09;
                            break;
                        }
                        case popUpControl:
                        {
                            winTempID = 0x10007L;
                            windKind = 0x0A;
                            break;
                        }
                        case radioControl:
                        {
                            winTempID = 0x10008L;
                            windKind = 0x0B;
                            break;
                        }
                        case scrollBarControl:
                        {
                            winTempID = 0x10009L;
                            windKind = 0x0C;
                            break;
                        }
                        case growControl:
                        {
                            winTempID = 0x1000AL;
                            windKind = 0x0D;
                            break;
                        }
                        case statTextControl:
                        {
                            winTempID = 0x1000BL;
                            windKind = 0x0E;
                            break;
                        }
                        case editTextControl:
                        {
                            winTempID = 0x1000CL;
                            windKind = 0x0F;
                            break;
                        }
                        case rectangleControl:
                        {
                            winTempID = 0x1000DL;
                            windKind = 0x10;
                            break;
                        }
                        case thermometerControl:
                        {
                            winTempID = 0x1000EL;
                            windKind = 0x11;
                            break;
                        }
		                default:
                        {
                            Data2PB.pCount = 5;
	                        Data2PB.resType = rAlertString;
	                        Data2PB.resID = 1L;
	                        Data2PB.special = 0;
	                        Data2PB.resFileID = edResFileID;
	                        resErr = fSpecialMagic(&DataPB);
                            action = AlertWindow(0x0032, 0L, DataPB.resData);
                            if (action) {
                                DataPB.pCount = 2;
                                DataPB.resType = p->resType;
                                DataPB.resID = p->resID;
                                fRequestEdit(&DataPB);
                                }
                            return;
                        }
                    }
                break;
            }

        case rCtlColorTbl:
            {
                windKind = 0x12;
                winTempID = 0x0600L;
                break;
            }
        case rWindColor:
            {
                windKind = 0x03;
                winTempID = 0x0300L;
                break;
            }

    case rMenuBar:
            {
                windKind = 0x13;
                winTempID = 0x0400L;
                break;
            }

    case rMenu:
            {
                windKind = 0x14;
                winTempID = 0x0200L;
                break;
            }
    case rMenuItem:
            {
                windKind = 0x15;
                winTempID = 0x0100L;
                break;
            }

    DataPB.pCount = 5;
	DataPB.resType = rWinParam1;
	DataPB.resID = winTempID;
	DataPB.special = 0;
	DataPB.resFileID = edResFileID;
	resErr = fSpecialMagic(&DataPB);

	title = NewHandle(128L, edUserID, 0x8018, 0L);

	NamePB.Pcount = 3;
	NamePB.resType = pString;
	NamePB.resID = p->resID;
	NamePB.resName = (Pointer) *title;
	resErr = fGetWindowTitle(&NamePB);

    (Handle) private = NewHandle(0x3aL, edUserID, 0x0018, 0L);
    pPtr = deref(private);
    pPtr->extraData = NewHandle(0x800, edUserID, 0x0018, 0L);
    pPtr->winP = NewWindow2(*title, 0L, 0L, 0L, 1, winTempID, 0x800e);
    AdjustWindow(pPtr->winP);
    PrivPB.pCount = 7;
	PrivPB.winPtr = pPtr->winP;
	PrivPB.TaskMask = 0L;		/* use standard task mask */
	PrivPB.remSignature = 0;    /* my personal signature - no significance */
	PrivPB.Data = private;
    PrivPB.groupSignature = 0x0020;
    PrivPB.resType = p->resType;
    PrivPB.resID = p->resID;
    fAddPrivateData(&PrivPB);

    pPtr->dirty = 0;
    pPtr->data = LoadRes(p->resType, p->resID);
	pPtr->title = title;

    switch (windKind) {
        case 0x01:      /* Window */
            {
	            pPtr->edTempH = (WinTemplateHndl) NewHandle(80L, edUserID, 0x8018, 0L);
	            pPtr->wkTempH = (WinTemplateHndl) NewHandle(80L, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edTempH, 80L);
                HandToHand(pPtr->data, pPtr->wkTempH, 80L);
                edWin = deref(pPtr->edTempH);
                wkWin = deref(pPtr->wkTempH);
                if (!edWin->plControlList)
                    SetWindMenu (0, pPtr->winP);
                pPtr->edTempH = (WinTemplateHndl) LoadRes(p->resType, p->resID);
                if bad
                    ;  /* perhaps put error alert here? */
                if ((edWin->plInDesc & 0xFF) == 9) {  /* ControlList Exists */
                    pPtr->wkCtlListH = (Handle) GetWkCtlList(edWin->plControlList);
                    wkWin->plControlList = pPtr->wkCtlListH;
                    wkWin->plInDesc &= 0xFF00;
                    wkWin->plInDesc |= 7;
                }
                if ((edWin->plInDesc & 0xFF) == 2) {  /* SingleControlExists */
                    pPtr->wkCtlListH = (Handle) GetWkCtl(edWin->plControlList);
                    wkWin->plControlList = pPtr->wkCtlListH;
                    wkWin->plInDesc &= 0xFF00;
                    wkWin->plInDesc |= 1;
                }
                if (edWin->plInDesc & 0x800) {  /* ColTableResource Exists */
                    wkWin->plColor = GetWinClrs(edWin->plColor);
                    wkWin->plInDesc &= 0xF3FF;
                    wkWin->plInDesc |= 0x0400;
                }
                if (edWin->plInDesc & 0x200)  Title Exists
                    wkWin->plTitle = GetWinTit(edWin->plTitle);
                    wkWin->plInDesc &= 0xFCFF;
                    wkWin->plInDesc |= 0x0100;
                }
                pPtr->edP = NewWindow2(0L, 0L, &EditWinProc, 0L, 1, pPtr->wkTempH, 0x800e);
                /* still need to set the local refcon */
                SetWorkingData(pPtr->winP, 0);
                break;
            }

        case 0x02:      /* Control List */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edTempH, hansize);

                SetWindMenu (0, pPtr->winP);
                pPtr->edP = NewWindow2(0L, 0L, &EditWinProc, 0L, 1, 0x0555L, 0x800e);
                AdjustWindow(pPtr->edP);
                wkPtr = deref(pPtr->wkCtlListH);
                for (i = 0; wkPtr[i] != 0L; i++)
                    tempCtl = NewControl2(pPtr->edP, 1, wkPtr[i]);
                /* still need to set the local refcon */
                SetWorkingData(pPtr->winP, 0);
                break;
            }
        case 0x03:      /* Window Color */
            {
            }
        case 0x04:      /* Simple Button */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1001,GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.BcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.BcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.BcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                SetCtlValue(1101 + (wkCtl.BcPtr->ctlTemplate.flag & 3),
                    GetCtlHandleFromID(winP, 0x1002L)); /* set button type */
                if (!wkCtl.BcPtr->keyEquivalent)
                    SetCtlValue(1 ,GetCtlHandleFromID(winP, 0x1003L));
                else                /* setting key equivs CB */
                    SetCtlValue(0 ,GetCtlHandleFromID(winP, 0x1003L));
                if (wkCtl.BcPtr->titleRef)
                    tempName = deref(GetResData(rPString, wkCtl.BcPtr->titleRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText[6], tempName);
                SetLETextByID(winP, 0x1008L, tempText[6]); /* setting title */
            }
        case 0x05:      /* Check Box */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1002,GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.CBcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.CBcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.CBcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (!wkCtl.CBcPtr->keyEquivalent)
                    SetCtlValue(1 ,GetCtlHandleFromID(winP, 0x1003L));
                else                /* setting key equivs CB */
                    SetCtlValue(0 ,GetCtlHandleFromID(winP, 0x1003L));
                if (wkCtl.CBcPtr->titleRef)
                    tempName = deref(GetResData(rPString, wkCtl.CBcPtr->titleRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText[6], tempName);
                SetLETextByID(winP, 0x1008L, tempText[6]); /* setting title */
                if (wkCtl.CBcPtr->initialValue)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1010L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1010L));
            }
        case 0x06:      /* Icon Button */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1003,GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.IcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.IcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.IcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                SetCtlValue(1101 + (wkCtl.IcPtr->ctlTemplate.flag & 3),
                    GetCtlHandleFromID(winP, 0x1002L)); /* set button type */
                if (!wkCtl.IcPtr->keyEquivalent)
                    SetCtlValue(1 ,GetCtlHandleFromID(winP, 0x1003L));
                else                /* setting key equivs CB */
                    SetCtlValue(0 ,GetCtlHandleFromID(winP, 0x1003L));
                if (wkCtl.IcPtr->titleRef)
                    tempName = deref(GetResData(rPString, wkCtl.IcPtr->titleRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText[6], tempName);
                SetLETextByID(winP, 0x1008L, tempText[6]); /* setting title */
                if (wkCtl.IcPtr->ctlTemplate.flag & 0x4)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1009L));
                else                /* setting show border checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1009L));
                if (wkCtl.IcPtr->ctlTemplate.flag & 0xFF00)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x100AL));
                else                /* setting inactive checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x100AL));
                if (wkCtl.IcPtr->displayMode)
                    {
                    if (wkCtl.IcPtr->displayMode & 4)
                        SetCtlValue(1, GetCtlHandleFromID(winP, 0x100DL));
                    else                /* setting offline checkbox */
                        SetCtlValue(0, GetCtlHandleFromID(winP, 0x100DL));
                    if (wkCtl.IcPtr->displayMode & 2)
                        SetCtlValue(1, GetCtlHandleFromID(winP, 0x100EL));
                    else                /* setting openIcon checkbox */
                        SetCtlValue(0, GetCtlHandleFromID(winP, 0x100EL));
                    if (wkCtl.IcPtr->displayMode & 1)
                        SetCtlValue(1, GetCtlHandleFromID(winP, 0x100FL));
                    else                /* setting selectedIcon checkbox */
                        SetCtlValue(0, GetCtlHandleFromID(winP, 0x100FL));
                    tempText[2][0] = (wkCtl.IcPtr->displayMode & 0xf000) >> 12;
                    tempText[2][1] = (wkCtl.IcPtr->displayMode & 0xf00) >> 8;
                    }
                else
                    {
                    tempText[2][0] = 0;
                    tempText[2][1] = 0xF;
                    }
            }
        case 0x07:      /* Edit Line */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1004,GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.LEcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.LEcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.LEcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.LEcPtr->defaultRef)
                    tempName = deref(GetResData(rPString, wkCtl.LEcPtr->defaultRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText[6], tempName);
                SetLETextByID(winP, 0x1012L, tempText[6]); /* setting title */
            }

        case 0x08:      /* List */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1005,GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.LcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.LcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.LcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                sprintf(tempText[3], "%0.2u", wkCtl.LcPtr->listMemHeight);
                SetLETextByID(winP, 0x1018L, tempText[6]); /* setting title */
                if (wkCtl.LcPtr->listType & 0x2)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1015L));
                else                /* setting multiselect checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1015L));
                if (wkCtl.LcPtr->listType & 0x4)
                    SetCtlValue(0x1601, GetCtlHandleFromID(winP, 0x1016L));
                else                /* setting multiselect checkbox */
                    SetCtlValue(0x1602, GetCtlHandleFromID(winP, 0x1016L));
            }
        case 0x09:      /* Picture */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1006,GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.PcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.PcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.PcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
            }
        case 0x0A:      /* PopUp Menu */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1007,GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.PmcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.PMcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0xFF00)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x100AL));
                else                /* setting inactive checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x100AL));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x101DL));
                else                /* setting white space checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x101DL));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x20)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x101EL));
                else                /* setting hilite title checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x101EL));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x4)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x101FL));
                else                /* setting keep in window checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x101FL));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x8)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1020L));
                else                /* setting show selection checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1020L));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x10)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1021L));
                else                /* setting Draw Title checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1021L));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x2)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1022L));
                else                /* setting RtJust Title checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1022L));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x1)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1023L));
                else                /* setting RtJust Select checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1023L));
                sprintf(tempText[4], "%0.3u", wkCtl.PmcPtr->titleWidth);
                SetLETextByID(winP, 0x1025L, tempText[4]); /* setting title width */
                sprintf(tempText[5], "%0.5u", wkCtl.PmcPtr->initialValue);
                SetLETextByID(winP, 0x1027L, tempText[5]); /* setting selected item */
            }
        case 0x0B:      /* Radio Button */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1008,GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.CBcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.CBcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.CBcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (!wkCtl.CBcPtr->keyEquivalent)
                    SetCtlValue(1 ,GetCtlHandleFromID(winP, 0x1003L));
                else                /* setting key equivs CB */
                    SetCtlValue(0 ,GetCtlHandleFromID(winP, 0x1003L));
                if (wkCtl.CBcPtr->titleRef)
                    tempName = deref(GetResData(rPString, wkCtl.CBcPtr->titleRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText[6], tempName);
                SetLETextByID(winP, 0x1008L, tempText[6]); /* setting title */
                if (wkCtl.CBcPtr->initialValue)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1010L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1010L));
            }
        case 0x0C:      /* Scroll Bar */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1009, GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.SBcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.SBcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.SBcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.SBcPtr->ctlTemplate.flag & 10)
                    temp = 0x1701;
                else
                    temp = 0x1702;
                if (wkCtl.SBcPtr->ctlTemplate.flag & 0xF)
                    temp += 2;
                SetCtlValue(temp, GetCtlHandleFromID(winP,0x1029L));
                sprintf(tempText[3], "%0.5u", wkCtl.SBcPtr->maxSize);
                SetLETextByID(winP, 0x102BL, tempText[3]); /* initial page */
                sprintf(tempText[4], "%0.5u", wkCtl.SBcPtr->viewSize);
                SetLETextByID(winP, 0x102BL, tempText[4]); /* initial value */
                sprintf(tempText[5], "%0.5u", wkCtl.SBcPtr->initialValue);
                SetLETextByID(winP, 0x102BL, tempText[5]); /* initial value */
            }

        case 0x0D:      /* Grow Box */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(100A, GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.GcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.GcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.GcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.GcPtr->ctlTemplate.flag & 0x1)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1030L));
                else                /* setting CallWindMgr checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1030L));
            }
        case 0x0E:      /* Static Text */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(0x100B, GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.STcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.STcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.STcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                temp = 0x1801;
                if (wkCtl.STcPtr->just)
                    {
                    if (wkCtl.STcPtr->just == 1)
                        temp = 0x1802;
                    if (wkCtl.STcPtr->just == -1)
                        temp = 0x1803;
                    if (wkCtl.STcPtr->just == 2)
                        temp = 0x1804;
                    }
                SetCtlValue(temp, GetCtlHandleFromID(winP, 0x1031L));
                temp = 0x1901;
                if (wkCtl.STcPtr->ctlTemplate.flag & 2)
                    {
                    if (wkCtl.STcPtr->ctlTemplate.flag & 1)
                        temp = 0x1903;
                    else
                        temp = 0x1902;
                    }
                SetCtlValue(temp, GetCtlHandleFromID(winP, 0x1032L));
            }
        case 0x0F:      /* Edit Text */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(0x100C, GetCtlHandleFromID(winP, 0x1000L));
                tempText[0] = deref(pPtr->extraData);
                sprintf(tempText[0], "%0.8lX", wkCtl.TEcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText[0]); /* setting ID */
                sprintf(tempText[1], "%0.8lX", wkCtl.TEcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText[1]); /* setting refCon */
                if (wkCtl.TEcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.TEcPtr->textFlags & 0x20000000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1034L));
                else                /* setting one style checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1034L));
                if (wkCtl.TEcPtr->textFlags & 0x10000000L)
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1035L));
                else                /* setting word wrap checkbox */
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1035L));
                if (wkCtl.TEcPtr->textFlags & 0x8000000L)
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1036L));
                else                /* setting scrolling checkbox */
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1036L));
                if (wkCtl.TEcPtr->textFlags & 0x4000000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1037L));
                else                /* setting Read Only checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1037L));
                if (wkCtl.TEcPtr->textFlags & 0x1000000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1038L));
                else                /* setting TabNextCtl checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1038L));
                if (wkCtl.TEcPtr->textFlags & 0x800000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1039L));
                else                /* setting Draw Frame checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1039L));
                if (wkCtl.TEcPtr->textFlags & 0x2000000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x103DL));
                else                /* setting Smart Cut/Paste checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x103DL));
                if (wkCtl.TEcPtr->textFlags & 0x200000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x103AL));
                else                /* setting Grow Ruler checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x103AL));
                if (wkCtl.TEcPtr->textFlags & 0x100000L)
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x103BL));
                else                /* setting Enable Selection checkbox */
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x103BL));
                if (wkCtl.TEcPtr->textFlags & 0x80000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x103CL));
                else                /* setting Box Inactive checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x103CL));

                if (wkCtl.TEcPtr->vertBar)



		/* [18] */  0x1103F,        /* vert Bar LE */
		/* [20] */  0x11041,        /* vert Scroll LE */
		/* [21] */  0x11042,        /* Text Mode PU */
		/* [23] */  0x11044,        /* maxChars LE */
	}
};


            }
        case 0x10:      /* Rectangle */
            {
            }
        case 0x11:      /* Thermometer */
            {
            }
        case 0x12:      /* Control Color */
            {
            }
        case 0x13:      /* MenuBar */
            {
            }

        case 0x14:      /* Menu */
            {
            }
        case 0x15:      /* MenuItem */
            {
            }
        }


	/*
		Now we set the data into the TE control, set the window colors,
		and show the window, completing the REM_OPEN call.
	*/

    return  0;
}

    The icon display Colors rectangle is...
	{126, 126, 136, 150},
	{130, 138, 140, 162},



word REM_CLOSE(fSessionRecPtr p)
{
GrafPortPtr winP;
PrivateDataHndl private;

    winP = p->windowPtr;

    PrivPB.pCount = 3;
    PrivPB.winPtr = winP;
    fGetPrivateData(&PrivPB);
    (Handle) private = PrivPB.Data;
    DisposeHandle((**Data).title);
    DisposeHandle((**Data).data);
    DisposeHandle((PrivPB.Data);

    return  0;
}

word REM_WRITE(fSessionRecPtr p)
{
    return  0;
}

word REM_EVENT(fEventRecPtr p)
{
    return  0;
}

word REM_ACTIVATE(fActivateRecPtr p)
{
privateDataHndl private;

	privPB.pCount = 4;
	privPB.winPtr = fEventPtr->wmTaskData;
	fGetPrivateData(&privPB);

	if (p->fFlag & ACTIVATE)
		p->fFlag |= (MENU_UNDO | MENU_CLIP | MENU_CLEAR | MENU_SELECT |MENU_APPLY);

    return  0;
}

/*	========================================================================
    REM_GETLINK is an extension to the shell's dependency knowlege.  Pascal
    Strings don't have dependents.  The supports REM_GETLINK rFlag bit 6 in
    the remStartRes is clear.

	Marc Wolfgram,  3/ 7/92  1:10:48
*/
word REM_GETLINK(fLinkRecPtr p)
{
    return  0;
}

/*	========================================================================
    REM_VIDMODE lets the editor know when it's world is changing.  We don't
    see a valid reason for a 320 mode Pascal String editor.  The 320 mode
    aware rFlag bit 4 in the remStartRes is clear.

	Marc Wolfgram,  3/ 7/92  1:03:41
*/
word REM_VIDMODE(fVidModeRecPtr p)
{
    return  0;
}

/*	========================================================================
    REM_PRINT must be supported entirely by the editor.  Why would we want
    to print a Pascal String?  We don't.

	Marc Wolfgram,  3/ 7/92  1:07:20
*/
word REM_PRINT(fPrintRecPtr p)
{
    return  0;
}

/*	========================================================================
    REM_STARTUP is called only when the REM is first loaded.

    The REM should do whatever it needs to do to setup globals, etc.

    This is the only time when the various Foundation and REM resource file
    ID's are passed to the REM.  Also, the REM's specific memory manager ID
    is passed here - READ THE WARNING IN REM_SHUTDOWN!

	Marc Wolfgram,  3/ 6/92 20:27:26
    ---------------------------------------------------------------
*/
word REM_STARTUP(fStartStopRecPtr p)
{
    ~USERID = edUserID = p->edUserID;
    edResFileID = p->edResFileID;
    shResFileID = p->shResFileID;
    fdResFileID = p->shResFileID;
    return  0;
}

/*	========================================================================
    REM_SHUTDOWN is called when an editor is unloaded.

    WARNING: The REM must release any memory alloceated at startup during
             the shutdown call.  There is no guarantee that once the editor
             is released that it will be reloaded.

	Marc Wolfgram,  3/ 6/92 20:41:12
    ---------------------------------------------------------------
*/
word REM_SHUTDOWN(fStartStopRecPtr p)
{
	DisposeAll(edUserID);	/* before assuming that this simplicity is 	*/
    return  0;				/* all you need, read TBR-1, page 12-23!	*/
}
